<?php
class FileUtil
{
	// Turn foo/../bar/../baz/ into baz/
	static function collapsePath( $p )
	{
	    $p = explode( '/', $p );
	    $o = array();
	    
	    for( $i = 0; $i < sizeof( $p ); $i++ )
	    {
	        // Skip meaningless . or empty terms.
	        if( $p[ $i ] == '' || $p[ $i ] == '.' )
	           continue;
	
	        // Consider if we can pop something off the list.
	        if( $p[ $i ] == '..' && $i > 0 && $o[ sizeof( $o ) - 1 ] != '..' )
	        {
	            array_pop( $o );
	            
	            continue;
	        }
	        
	        array_push( $o, $p[ $i ] );
	    }
	    
	    return implode( '/', $o );
	}
	
	// We apply some cleanup to the file list, specifically to remove
	// any groupings with no siblings.
	static function trimFileList( &$list )
	{
	   // Consider each child...
	   foreach( $list as $k => $v )
	   {
	      // Only consider folders...
	      if( !is_array( $v ) )
	         continue;
	
	      // If child has only one child, then collapse it
	      reset( $v );
	      
	      if( count( $v ) == 1 && is_array( current( $v ) ) ) 
	      {
	         //echo("Trying to collapse $k\n");
	         
	         $list[ $k ] = current( $v );
	
	         // Reset our walk through the list...
	         reset( $list );
	      }
	   }
	
	   // Now recurse on all children.
	   foreach( $list as $k => $v )
	   {
	      // Only consider folders...
	      if( !is_array( $v ) )
	         continue;
	
	      FileUtil::trimFileList( &$list[ $k ] );
	   }
	}
	
	static function prepareOutputDir( $outdir )
	{
		if( !file_exists( $outdir ) ) 
		{
			echo( " Directory " . $outdir . " doesn't exist, attempting to create it.\n" );
	
			if( !mkdir_r( $outdir, 0777 ) ) 
			{
				echo( " Couldn't create directory.\n" );
	
				return false;
			}
		}
	
		if( !chdir( $outdir ) ) 
		{
			echo( "Couldn't change directory\n" );
	
			return false;;
		}
		
		return true;
	}

   static function normalizeSlashes( $path )
   {
      return str_replace( '\\', '/', $path );
   }
   
   static function isAbsolutePath( $path )
   {
      // check for VC++ environment variables and consider
      // them absolute paths
      if(strcasecmp(substr($path, 0, 2), '$(') == 0)
         return true;

      // This looks complex, but its really fairly simple.
      //
      // We're detecting existing absolute paths in the include
      // by converting it to absolute, normalizing the slashes,
      // and comparing the results.
      //
      // If we get an absolute path we just don't prepend the
      // project relative path part.
      //
      $orgPath = FileUtil::normalizeSlashes( $path );
      $absPath = FileUtil::normalizeSlashes( realpath( $path ) );
      return strcasecmp( $orgPath, $absPath ) == 0;
   }

	static function isEnvVarPath($path, &$envVar, &$envValue, &$envPath)
	{
		// parsing expression for matching:
		//   $(ENVVARNAME)/Path/to/something
		//   ${ENVVARNAME}/Path/to/something
		$exp = '/^.*\$(\(|\{)(.+)(\)|\})(.+)$/';
		$res = array();

		if(preg_match($exp, $path, $res) != 1)
			return false;

		$envVar =  '$' . $res[1] . $res[2] . $res[3];
		$envPath = $res[4];
		$envValue = getenv($res[2]);

		return true;
	}

	static function repackEnvVarPath($envVar, $envValue, $absPath)
	{
		// yes this cheating a bit
		$trail = substr($absPath, strlen($envValue));

		return $envVar . $trail;
	}

}
?>
