<?php

function checkEnvVar($evar)
{
	// does the environment variable exist?
	if(!($value = getenv($evar)))
		return false; // nope

	// verify that the environment variable is set to an existing path
	if(!file_exists($value))
		return false; // no such path

	// environment variable checks out, return it
	return $evar;
}


beginModule( 'physX' );

	// default to failure
	$isValid = false;
	$isAbsPath = false;

	// Look for the optional global variable from the project.conf file.
	global $PHYSX_SDK_PATH;

	if(isset($PHYSX_SDK_PATH))
	{
		// Validate the provided file path given to us via project.conf file
		if(file_exists($PHYSX_SDK_PATH))
		{
			$isValid = true;
			$isAbsPath = true;
			break;
		}
	} else
	{
		// Absolute path wasn't provided for us in the project.conf file, so
		// we'll search for it ourselves.

		// this is not for looping, but for an easy escape vector
		while(true)
		{
			// check for the environment variable
			if(($PHYSX_SDK_PATH = checkEnvVar("TORQUE_PHYSX_PATH")));
			{
				$isValid = true;
				break;
			}

			// check for the alternative environment variable
			if(($PHYSX_SDK_PATH = checkEnvVar("PHYSX_SDK_PATH")));
			{
				$isValid = true;
				break;
			}

			// check for the common path (Windows)
			$PHYSX_SDK_PATH = getenv("ProgramFiles") . "/NVIDIA Corporation/NVIDIA PhysX SDK/v2.8.4_win";
			if(file_exists($PHYSX_SDK_PATH))
			{
				$isValid = true;
				$isAbsPath = true;
				break;
			}

			// check for the common 32bit path on 64bit OS (Windows)
			$PHYSX_SDK_PATH = getenv("ProgramFiles(x86)") . "/NVIDIA Corporation/NVIDIA PhysX SDK/v2.8.4_win";
			if(file_exists($PHYSX_SDK_PATH))
			{
				$isValid = true;
				$isAbsPath = true;
				break;
			}

			break;
		}
	}

	if($isValid)
	{
		if($isAbsPath)
		{
			// We need forward slashes for paths.
			$PHYSX_SDK_PATH = str_replace( "\\", "/", $PHYSX_SDK_PATH);

			// Remove trailing slashes.
			$PHYSX_SDK_PATH = rtrim($PHYSX_SDK_PATH, " /");
		} else
		{
//			$PHYSX_SDK_PATH = getenv($PHYSX_SDK_PATH);
			$PHYSX_SDK_PATH = '$('. $PHYSX_SDK_PATH .')';
		}
	}


   // If we still don't have the SDK path then let the user know.
   if(!$isValid)
   {
      trigger_error( 
            "\n*******************************************************************".
            "\n".
            "\n  We were not able to find a valid path to the PhysX SDK!".
            "\n".
            "\n  You must install the latest PhysX SDK and set the path via a".
            "\n  \$PHYSX_SDK_PATH variable in your buildFiles/project.conf file".
            "\n  or by setting the TORQUE_PHYSX_PATH system environment variable".
            "\n  (may require a reboot).".
            "\n".
            "\n*******************************************************************".
            "\n", E_USER_ERROR );
   }

   addProjectDefine( "TORQUE_PHYSICS_PHYSX" );
   addProjectDefine( "TORQUE_PHYSICS_ENABLED" );

   // Source
   addEngineSrcDir( "T3D/physics/physX" );

   // Includes
   addIncludePath( $PHYSX_SDK_PATH . "/SDKs/Physics/include" );
   addIncludePath( $PHYSX_SDK_PATH . "/SDKs/Foundation/include" );
   addIncludePath( $PHYSX_SDK_PATH . "/SDKs/PhysXLoader/include" );
   addIncludePath( $PHYSX_SDK_PATH . "/SDKs/Cooking/include" );
   addIncludePath( $PHYSX_SDK_PATH . "/SDKs/NxCharacter/include" );
   addIncludePath( $PHYSX_SDK_PATH . "/Tools/NxuStream2" );

   // Libs
   addProjectLibDir( $PHYSX_SDK_PATH . "/SDKs/lib/Win32" );
   addProjectLibInput( "PhysXCooking.lib" );
   addProjectLibInput( "PhysXLoader.lib" );

   // For PhysX support.
   includeLib( 'nxCharacter' );
   includeLib( 'nxuStream' );

   if (inProjectConfig())
   {
      addProjectDependency( 'nxCharacter' );
      addProjectDependency( 'nxuStream' );
      addSolutionProjectRef( 'nxCharacter' );
      addSolutionProjectRef( 'nxuStream' );
   }

endModule();

?>
