<?php
//-----------------------------------------------------------------------------
// Copyright (c) 2012 GarageGames, LLC
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//-----------------------------------------------------------------------------

// This class wraps up some project generator specific stuff for the Torque Game Engine project itself
// simplifying the per project setup, while still allowing the engine to have modules plugged in

class TGE
{
    static $sharedConfig = false;
    static $projectName = "";
    
    static function includeDefaultLibs()
    {
        // Libs
		if(T3D_Generator::$platform == "win32")
		{
			includeLib( 'opengl2d3d' );
			includeLib( 'glu2d3d' );
		}
        includeLib( 'jpeg' );
        includeLib( 'png' );
        includeLib( 'ungif' );
        includeLib( 'zlib' );

        if ( true )
        {
           includeLib( 'libvorbis' );
           includeLib( 'libogg' );
           includeLib( 'libtheora' );
        }
        
        // tools and things
        includeLib( 'TGEToolsLib' );
        includeLib( 'dtsSDK' );
        includeLib( 'dtsSDKPlus' );
        if(T3D_Generator::$platform == "win32")
        {
            includeLib( 'max2dtsExporter' );
//            includeLib( 'max2dtsExporterPlus' );
	        includeLib( 'max2mapExporter' );
	        includeLib( 'maya2dtsExporter' );
	        includeLib( 'ms2dtsExporter' );
        }
        
        includeLib( 'buildWad' );
        includeLib( 'fonttool' );
        includeLib( 'langc' );
        includeLib( 'map2dif' );
        includeLib( 'map2difPlus' );
    }
    
    static function beginConfig( $platform, $projectName, $destDir = '', $outputName = '' )
    {
        global $argv;

        setPlatform( $platform );

        beginProject( $projectName, self::$sharedConfig );
        
        self::includeDefaultLibs();
        
        $ext = "DLL";
        if ( T3D_Generator::$platform == "mac" )
            $ext = "Bundle";

		if(!isset($destDir) || $destDir == '')
			$destDir = T3D_Generator::$defaultGameDir;
		if(!isset($outputName) || $outputName == '')
			$outputName = getGameProjectName();

        //begin either a shared lib config, or a static app config
        if ( self::$sharedConfig )
            beginSharedLibConfig( getGameProjectName().' '.$ext, '{1B534367-5310-4FFA-B5C0-873393712AFB}', $destDir, $outputName );
        else
            beginAppConfig( getGameProjectName(), '{1B534367-5310-4FFA-B5C0-873393712AFB}', $destDir, $outputName );
        
        /// Prefs
//        addProjectDefine( 'TORQUE_SHADERGEN' );
//        addProjectDefine( 'TORQUE_UNICODE' );
        
        if ( self::$sharedConfig )
           addProjectDefine( 'TORQUE_SHARED' );    

        
        // Additional includes
        
		if($platform == "win32")
		{
			addLibIncludePath( "opengl2d3d" );
			addLibIncludePath( "glu2d3d" );
		}
        addLibIncludePath( "ljpeg" );
        addLibIncludePath( "lpng" );
        addLibIncludePath( "lungif" );
        addLibIncludePath( "zlib" );
        
        if ( true )
        {
          addLibIncludePath( "libvorbis/include" );
          addLibIncludePath( "libogg/include" );
          addLibIncludePath( "libtheora/include" );
        }
        
        // Modules
        includeModule( 'TGE' );
        
        if ( false )
        {
          includeModule( 'vorbis' );
          includeModule( 'theora' );
        }
       
        if(false)
           includeModule( 'openal' );

   
        // Dependencies
		if($platform == "win32")
		{
			addProjectDependency( "opengl2d3d" );
			addProjectDependency( "glu2d3d" );
		}
        addProjectDependency( "ljpeg" );
        addProjectDependency( "lpng" );
        addProjectDependency( "lungif" );
        addProjectDependency( "zlib" );

        
        if ( true )
        {
          addProjectDependency( 'libvorbis' );
          addProjectDependency( 'libogg' );
          addProjectDependency( 'libtheora' );
        }
        
        if ( T3D_Generator::$platform == "mac" )
        {    
            addProjectDefine( '__MACOSX__' );
            addProjectDefine( 'LTM_DESC' );
        }

        if (T3D_Generator::$platform == "win32")
        {
//            setProjectModuleDefinitionFile('../../' . getLibSrcDir() . 'Torque3D/msvc/torque3d.def');

//            addProjectDefine( 'UNICODE' );
//            addProjectDefine( 'INITGUID' );
            addProjectDefine( '_CRT_SECURE_NO_DEPRECATE' );
            

            addProjectLibInput('COMCTL32.LIB');
            addProjectLibInput('COMDLG32.LIB');
            addProjectLibInput('USER32.LIB');
            addProjectLibInput('ADVAPI32.LIB');
            addProjectLibInput('GDI32.LIB');
            addProjectLibInput('WINMM.LIB');
            addProjectLibInput('WSOCK32.LIB');
            addProjectLibInput('vfw32.lib');
            addProjectLibInput('Imm32.lib');
            addProjectLibInput('d3d9.lib');
            addProjectLibInput('d3dx9.lib');
            addProjectLibInput('DxErr.lib');
            addProjectLibInput('ole32.lib');
            addProjectLibInput('shell32.lib');
            addProjectLibInput('oleaut32.lib');
            addProjectLibInput('version.lib');
            addProjectLibInput('Shlwapi.lib');
            addProjectLibInput('Rpcrt4.lib');
        }
        
        // Include project specific sources in the project/buildFiles/config/projectCode.conf
        $projectCode = realpath(dirname($argv[1])) . "/projectCode.conf";
        echo( "\n   - Loading project code configuration from ".$projectCode."\n");
        include $projectCode;
    }
    
    static function endConfig()
    {
        //end shared/static config
        if ( self::$sharedConfig )
           endSharedLibConfig();
        else
           endAppConfig();

        //add the shared application only if this is a shared config
        if ( self::$sharedConfig )
        {
            /////// Application Config
            beginSharedAppConfig( getGameProjectName(), '{2EC49497-9FD4-467E-AECF-01357B3BB9BA}' );

                addProjectDefine( 'TORQUE_SHARED' );

                addEngineSrcDir( 'main' );
                
                if (T3D_Generator::$platform == "win32")
                {
                    addProjectDefine( 'WIN32' );
                    addProjectDependency( getGameProjectName() . ' DLL' );
                }

                if (T3D_Generator::$platform == "mac")
                {
                    addProjectDefine( '__MACOSX__' );
                    addProjectDependency( getGameProjectName() . ' Bundle' );
                    addProjectDependency( getGameProjectName() . ' Plugin' );
                }

            endSharedAppConfig();
        }
        
        // Add solution references for Visual Studio projects
        if (T3D_Generator::$platform == "win32")
        {
           if ( !self::$sharedConfig )
              beginSolutionConfig( getGameProjectName(), '{35FEDE51-98C6-4B39-846D-CD4B9A02824F}' );
              
              addSolutionProjectRef( getGameProjectName() );
              if ( self::$sharedConfig )
                 addSolutionProjectRef( getGameProjectName() . ' DLL' );
                 
              addSolutionProjectRef( 'glu2d3d' );
              addSolutionProjectRef( 'ljpeg' );
              addSolutionProjectRef( 'lpng' );
              addSolutionProjectRef( 'lungif' );
              addSolutionProjectRef( 'opengl2d3d' );
              addSolutionProjectRef( 'zlib' );
              
              if (true)
              {
                 addSolutionProjectRef( 'libogg' );
                 addSolutionProjectRef( 'libvorbis' );
                 addSolutionProjectRef( 'libtheora' );
              }

              // tools and things
              addSolutionProjectRef( 'Torque Tool Lib' );
              addSolutionProjectRef( 'dtsSDK' );
              addSolutionProjectRef( 'dtsSDKPlus' );
              addSolutionProjectRef( 'max2dtsExporter' );
//              addSolutionProjectRef( 'max2dtsExporterPlus' );
              addSolutionProjectRef( 'max2mapExporter' );
              addSolutionProjectRef( 'maya2dtsExporter' );
              addSolutionProjectRef( 'ms2dtsExporter' );

              addSolutionProjectRef( 'buildWad' );
              addSolutionProjectRef( 'fonttool' );
              addSolutionProjectRef( 'langc' );
              addSolutionProjectRef( 'map2dif' );
              addSolutionProjectRef( 'map2difPlus' );
              
           if ( !self::$sharedConfig )
              endSolutionConfig();
        }
        
        endProject(self::$sharedConfig);
        
    }
        
}

?>