<?php
//-----------------------------------------------------------------------------
// Copyright (c) 2012 GarageGames, LLC
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//-----------------------------------------------------------------------------

// Module
beginModule( 'TGEToolsLib' );
endModule();

includeModule( 'TGE_core' );

removeEngineSrcFile('audio/vorbisStreamSource.*');
removeEngineSrcFile('audio/vorbisStream.*');
removeEngineSrcFile('audio/oggMixedStreamSource.*');
removeEngineSrcFile('core/theoraPlayer.*');
removeEngineSrcFile('game/main.cc');
removeEngineSrcFile('gui/containers/guiTabBookCtrl.*');
removeEngineSrcFile('gui/controls/guiTabPageCtrl.*');
removeEngineSrcFile('gui/shiny/guiTheoraCtrl.*');
removeEngineSrcFile('gui/editor/*');
removeEngineSrcFile('editor/*');

// platform specific stuff.
switch(T3D_Generator::$platform)
{
	case "win32":
		addEngineSrcFile('platformWin32/*');
		removeEngineSrcFile('platform/platformNetAsync.unix.cc');
		removeEngineSrcFile('platformWin32/d3dgl.cc');
		removeEngineSrcFile('platformWin32/winVFS.cc');
		break;

	case "mac":
		addEngineSrcFile('platformOSX/*');
		
		// can't use .asm files at the moment, fall back to C files instead
		removeEngineSrcFile('*.asm');

		if (getProjectSubSystem() == Project::$SUBSYS_CONSOLE)
			removeEngineSrcFile('platformOSX/main.mm');
		else
			removeEngineSrcFile('platformOSX/toolMain.mm');

		addEngineSrcFile('interior/itfdump_c.cc');
		break;

	case "linux":
		addEngineSrcFile('platformX86UNIX/*');
		removeEngineSrcFile('platformX86UNIX/x86UNIXDedicatedStub.cc');
		break;

	case "linux_dedicated":
		removeEngineSrcFile('audio/vorbisStream*.*');
		addEngineSrcFile('platformX86UNIX/*');
		removeEngineSrcFile('platformX86UNIX/x86UNIXAsmBlit.cc');
		removeEngineSrcFile('platformX86UNIX/x86UNIXFont.cc');
		removeEngineSrcFile('platformX86UNIX/x86UNIXGL.cc');
		removeEngineSrcFile('platformX86UNIX/x86UNIXInput.cc');
		removeEngineSrcFile('platformX86UNIX/x86UNIXInputManager.cc');
		removeEngineSrcFile('platformX86UNIX/x86UNIXOGLVideo.cc');
		removeEngineSrcFile('platformX86UNIX/x86UNIXOpenAL.cc');
		break;
}


/////////////////////
// Additional includes
//addIncludePath( '../../source' );		   // product source (relative to solution output directories)
addIncludePath( getAppEngineSrcDir() );	// main engine source dir relative to app project file 
addIncludePath( getAppLibSrcDir() ); 	   // main lib source dir relative to app project file

if(T3D_Generator::$platform == "win32")
{
   addIncludePath( getAppLibSrcDir() . 'directx8' );
   addIncludePath( getAppLibSrcDir() . 'openal/win32' );
   
//   addProjectLibDir( getAppLibSrcDir() . 'SDL/win32' );
//   addProjectLibDir( getAppLibSrcDir() . 'unicode' );
   addProjectLibDir( getAppLibSrcDir() . 'directx8' );
}

// TODO: add a test to determine if its set for Torque app before adding it here
addProjectDefine('UNICODE');
addProjectDefine('TORQUE_LIB');
addProjectDefine('TORQUE_NO_OGGVORBIS');

// additional includes
addLibIncludePath( "ljpeg" );
addLibIncludePath( "lpng" );
addLibIncludePath( "lungif" );
addLibIncludePath( "zlib" );
addLibIncludePath( "xiph/include" );

// Dependencies
addProjectDependency( "ljpeg" );
addProjectDependency( "lpng" );
addProjectDependency( "lungif" );
addProjectDependency( "zlib" );

?>
