<?php
//-----------------------------------------------------------------------------
// Copyright (c) 2012 GarageGames, LLC
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//-----------------------------------------------------------------------------

beginModule('buildWad');

setProjectSubSystem(Project::$SUBSYS_CONSOLE);

// Source
addSrcDir(T3D_Generator::getToolsDir() . 'buildWad');

// Additional includes
addIncludePath(getAppEngineSrcDir()); // engine/
addIncludePath(getAppEngineToolsDir()); // tools/

// Defines
addProjectDefine('TORQUE_LIB');
addProjectDefine('NO_OGGVORBIS');

// Dependencies
addProjectDependency('Torque Tool Lib');
addProjectDependency('zlib');
addProjectDependency('lungif');
addProjectDependency('lpng');
addProjectDependency('ljpeg');

if(T3D_Generator::$platform == 'win32')
{
	addProjectLibInput('WSOCK32.LIB');
	addProjectLibInput('Imm32.lib');
	addProjectLibInput('WINMM.LIB');
	addProjectLibInput('COMCTL32.LIB');
	addProjectLibInput('Rpcrt4.lib');
}

endModule();
?>