<?php

function PagePreHTML()
{
	
} // PagePreHTML()


function timeFormatData(&$row, $key)
{
	return sprintf('[(%u * 1000), %s]', $row['timeRecorded'], $row[$key]);
}

function PagePostHTML()
{

	$results = DBGetMasterStats(24);
	foreach($results as $k => $row)
	{
		$collect['activeServers'	][]	= timeFormatData($row, 'activeServers');
		$collect['newHosts'			][]	= timeFormatData($row, 'newHosts');
		$collect['updatedHosts'		][]	= timeFormatData($row, 'updatedHosts');
		$collect['newServers'		][]	= timeFormatData($row, 'newServers');
		$collect['updatedServers'	][]	= timeFormatData($row, 'updatedServers');
		$collect['serversDifferent'	][]	= timeFormatData($row, 'serversDifferent');
//		$collect['timeRecorded'		][]	= timeFormatData($row, 'timeRecorded');

	}

	$collection = array('Active'	=> $collect['activeServers'],
						'Updated'	=> $collect['updatedServers'],
						'Changed'	=> $collect['serversDifferent'],
						'New'		=> $collect['newServers']
						);
	$encoded = '';
	foreach($collection as $k => $row)
	{
		$data = "{\n";

		$data .= sprintf("name: '%s',\n".
						"data: [%s]\n",
						$k,
						join($row, ","));

		$data .= "}";
		$encoded[] = $data;
	}

	$encoded = join($encoded, ',');
	$servers = DBGetActiveServers(10, 50);
?>

	<script type="text/javascript">
	
		var chart;
		$(document).ready(function() {
			chart = new Highcharts.Chart({
				chart: {
					renderTo: 'masterStats', 
					defaultSeriesType: 'area'
				},
				title: {
					text: 'Master Server Stats'
				},
				subtitle: {
					text: 'Source: master.garagegames.com'
				},
				xAxis: {

					title: {
						text: 'UTC Time'
					},
/*					labels: {
						formatter: function() {
							return this.value; // clean, unformatted number for year
						}
					}
*/
					type: 'datetime',
					dateTimeLabelFormats: { // don't display the dummy year
						month: '%e. %b',
						year: '%b'
					}
				},
				yAxis: {
					title: {
						text: 'Game Servers'
					},
					labels: {
						formatter: function() {
							return this.value + '';
						}
					}
				},

				tooltip: {
					formatter: function() {
						return '<b>'+ Highcharts.numberFormat(this.y, 0) +'</b> '+ this.series.name +' Servers <br>'+
								Highcharts.dateFormat('%A, %B %e, %Y<br>%I:%M:%S %p (GMT 00:00)', this.x);
					}
				},

				plotOptions: {
					area: {
						marker: {
							enabled: false,
							symbol: 'circle',
							radius: 2,
							states: {
								hover: {
									enabled: true
								}
							}
						}
					}
				},

				series: [<?php print($encoded); ?>]
			});
			
			
		});
	</script>


<div id="masterStats" style="width: %80; height: 350px; margin: 0 auto"></div>
<br>

<?php print($servers->RecordCount()) ?> Currently active servers:
<table class="servers">
<thead><tr><th>ID #</th> <th>Game</th> <th>Status</th> <th>Name</th> <th>Players</th> <th>Version</th> <th>CPU MHz</th> <th>Host:Port</th></tr></thead>
<tbody>
<?php

	$class = 1;
	$tfmt = 'h:i A';
	foreach($servers as $k => $row)
	{
		$status = genServerStatus($row['status']);

		$class = !$class;
		printf('<tr class="%s"><td class="tnum">%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td class="tnum">%s</td> <td class="tnum">%s</td> <td class="tnum">%s</td> <td class="tnum">%s</td></tr>' . "\n",
			(($class)? 'servlist1':'servlist2'),
			sprintf('<a href="?p=%s&amp;sid=%u">%u</a>', 'server', $row['serverID'], $row['serverID']),
			HTMLSafe($row['gameTypeName']),
			$status,
			HTMLSafe($row['name']),
			sprintf("%u/%02u", $row['playerCount'], $row['playerMax']),
			$row['gameVersion'],
			$row['cpuSpeed'],
			sprintf("%s:%u", $row['address'], $row['port'])

/*
//			'<a href="?p='. $page .'&c='. $cate .'&i='. $row['TimeID'] .'">'. $row['TimeID'] .'</a>',
			$row['activeServers'],
			$row['newHosts'],
			$row['updatedHosts'],
			$row['newServers'],
			$row['updatedServers'],
			$row['serversDifferent'],
//			date('Y-m-d - l h:i A', strtotime($row['tsRecorded']))
			date('Y-m-d - l h:i A', $row['timeRecorded'])
//			$row['timeRecorded']
*/
		);
	}
?>
<tfoot><tr><td></td> <td></td> <td></td> <td></td> <td></td> <td></td> <td></td> <td></td></tr></tfoot>
</tbody></table>

<?php

} // PagePostHTML()
?>
