<?php

$server = array();


function PagePreHTML()
{
	global $app, $server;

	// set default values
	$title			= $app['title'];
	$server			= NULL;
	$app['title']	= sprintf('%s - %s', '[Server Not Found]', $title);

	// abort if serverID not provided
	if(!isset($_GET['sid']))
		return;

	// get server record, abort if not found
	$result = DBGetServer($_GET['sid'] +0);
	if($result === false)
		return;

	// store server record and update title to include server's name
	$server			= $result->fields;
	$app['title']	= sprintf('%s - %s', HTMLSafe($server['name']), $title);

	// done

} // PagePreHTML()

function timeFormatData(&$row, $key)
{
	return sprintf('[(%u * 1000), %s]', $row['timeMatched'], $row[$key]);
}

function PagePostHTML()
{
	global $server;

	if($server == NULL)
	{
		print("Server Not Found.\n");
		return;
	}

?>
This Torque Network Browser feature is a work in Progress.<br><br>
<?php

	// dump server array
//	echo('<pre>'); print_r($server); echo('</pre>');
//	echo( HTMLSafe(var_export($server, true)) );
	Safeprint_r($server);


	$results = DBGetServerHistory($server['serverID'], 24);
	$lastTS  = 0;
	foreach($results as $k => $row)
	{
		if($lastTS == 0)
			$lastTS = $row['timeMatched'];
/*
		if(($row['timeMatched'] - $lastTS) > (30 * 60))
		{
			$noData = array('timeMatched' => ($lastTS + 60), 'ND' => 'null');
			$NULL = timeFormatData($noData, 'ND');

			$collect['playerCount'	][]	= $NULL;
			$collect['playerMax'	][] = $NULL;
			$collect['botCount'		][] = $NULL;
		}
*/
		$collect['playerCount'	][]	= timeFormatData($row, 'playerCount');
		$collect['playerMax'	][]	= timeFormatData($row, 'playerMax');
		$collect['botCount'		][]	= timeFormatData($row, 'botCount');

		$lastTS = $row['timeMatched'];
	}

	$collection = array('Active players'	=> $collect['playerCount'],
						'Maximum players'	=> $collect['playerMax'],
						'Bots'				=> $collect['botCount'],
						);
	$encoded = '';
	foreach($collection as $k => $row)
	{
		$data = "{\n";

		$data .= sprintf("name: '%s',\n".
						"data: [%s]\n",
						$k,
						join($row, ","));

		$data .= "}";
		$encoded[] = $data;
	}

	$encoded = join($encoded, ',');
?>


	<script type="text/javascript">
	
		var chart;
		$(document).ready(function() {
			chart = new Highcharts.Chart({
				chart: {
					renderTo: 'serverPlayersStats', 
					defaultSeriesType: 'area'
				},
				title: {
					text: 'Player Stats'
				},
				subtitle: {
					text: ''
				},
				xAxis: {

					title: {
						text: 'UTC Time'
					},
/*					labels: {
						formatter: function() {
							return this.value; // clean, unformatted number for year
						}
					}
*/
					type: 'datetime',
					dateTimeLabelFormats: { // don't display the year
						month: '%e. %b',
						year: '%b'
					}
				},
				yAxis: {
					title: {
						text: 'Players'
					},
					labels: {
						formatter: function() {
							return this.value + '';
						}
					}
				},

				tooltip: {
					formatter: function() {
						return '<b>'+ Highcharts.numberFormat(this.y, 0) +'</b> '+ this.series.name +' on server<br>'+
								Highcharts.dateFormat('%A, %B %e, %Y<br>%I:%M:%S %p (GMT 00:00)', this.x);
					}
				},

				plotOptions: {
					area: {
						marker: {
							enabled: false,
							symbol: 'circle',
							radius: 2,
							states: {
								hover: {
									enabled: true
								}
							}
						}
					}
				},

				series: [<?php print($encoded); ?>]
			});
			
			
		});
	</script>


<div id="serverPlayersStats" style="width: %80; height: 350px; margin: 0 auto"></div>

Server history of the last 24 hours:
<table class="servers">
<thead>
	<td>gameType</td> <td>missionType</td> <td>Status</td> <td>Players (Bots)</td> <td>cpuSpeed</td> <td>gameVersion</td> <td>Name</td> <td>Mission Name</td> <td>Info</td> <td>Extended Info</td>
</thead>
<tbody>
<?php

	$class = 1;
	foreach($results as $k => $row)
	{
		$class = !$class;

		printf(
			'<tr class="%s"><td>%s</td> <td>%s</td> <td class="tnum">%s</td> <td class="tnum">%s</td> <td class="tnum">%s</td> <td class="tnum">%s</td> <td>%s</td> <td>%s</td> <td>%s</td> <td>%s</td></tr>'. "\n",

			(($class)? 'servlist1':'servlist2'),
			sprintf('"%s"(%u)', $row['gameTypeName'], $row['gameType']),
			sprintf('"%s"(%u)', $row['missionTypeName'], $row['missionType']),
			sprintf('%s (0x%02X)', genServerStatus($row['status']), $row['status']),
			sprintf('%u/%02u (%02u)', $row['playerCount'], $row['playerMax'], $row['botCount']),
			$row['cpuSpeed'],
			$row['gameVersion'],
			HTMLSafe($row['name']),
			HTMLSafe($row['missionName']),
			HTMLSafe($row['info']),
			HTMLSafe($row['infoLong'])
		);
	}

?>
</tbody>
</table>
<?php

} // PagePostHTML()
?>
