<?php
/**************************************************************************
 *  Torque Server Query PHP Script
 *  Copyright (C) 2011-2012 by Nathan Martin  All Rights Reserved
 *
 *  Author can be contacted at nmartin <AT> gmail [DOT] com
 *  This source code is licensed under the General Public License (GPL) v2
 *  License info: http://www.gnu.org/copyleft/gpl.html
 *
 *=========================================================================
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *************************************************************************/

// global variables
$app['title']			= 'Torque Network Browser';
$app['page']			= 'main';
$app['imageBase']		= './tnm/imgs/';

$setup['db_host']		= 'localhost';
$setup['db_user']		= 'tgeMasterBrowsRO';	// Read-Only access
$setup['db_pass']		= 'ReadOnlyPassGoesHere';
$setup['db_base']		= 'tgeMasterBrowser';


require("adodb5/adodb-exceptions.inc.php"); 
require('adodb5/adodb.inc.php');



//error_reporting(E_ERROR | E_PARSE | E_NOTICE);
error_reporting(E_ALL);

// we want GZip compression enabled
ob_start("ob_gzhandler");


//=============================================================================
// Database Management
//=============================================================================

function DBConnect()
{
	global $DBC, $setup;

	try
	{
		$DBC = &ADONewConnection('mysql');
		$DBC->PConnect($setup['db_host'], $setup['db_user'], $setup['db_pass'], $setup['db_base']);
		$DBC->SetFetchMode(ADODB_FETCH_ASSOC);
//		$ADODB_FETCH_MODE = ADODB_FETCH_ASSOC;

	} catch (exception $e)
	{
//		Safevar_dump($e); 
//		adodb_backtrace($e->gettrace());

		return false;
	}

	return true;
}

function DBHandleGameType(&$server)
{
	global $DBC, $stats;

	try
	{
		// see if game type exists in our games table
		$sql = "SELECT * FROM `games` WHERE `gameName` = ? LIMIT 1;";
		$res = $DBC->Execute($sql, array($server['gameType']));

		if($res->fields)
		{
			$ID = $res->fields['gameID'];

			// successfully got ID, now update last seen timestamp
			$sql = "UPDATE `games` SET `tsLastSeen`=CURRENT_TIMESTAMP() WHERE `gameID`='". $ID ."';";
			$DBC->Execute($sql);

			$server['gameType'] = $ID;

			// return host ID
			return $ID;
		}

		// game type isn't in our database, insert it
		$sql = "INSERT INTO `games` (gameName, tsFirstSeen) VALUES (?, CURRENT_TIMESTAMP);";
		$res = $DBC->Execute($sql, array($server['gameType']));
		$ID  = $DBC->Insert_ID();

		$server['gameType'] = $ID;

		// return host ID
		return $ID;

	} catch (exception $e)
	{
		Safevar_dump($e);
		adodb_backtrace($e->gettrace());

		return false;
	}
}

function DBHandleMissionType(&$server)
{
	global $DBC, $stats;

	try
	{
		// see if mission type exists in our missions table
		$sql = "SELECT * FROM `missions` WHERE `missionName` = ? LIMIT 1;";
		$res = $DBC->Execute($sql, array($server['missionType']));

		if($res->fields)
		{
			$ID = $res->fields['missionID'];

			// successfully got ID, now update last seen timestamp
			$sql = "UPDATE `missions` SET `tsLastSeen`=CURRENT_TIMESTAMP() WHERE `missionID`='". $ID ."';";
			$DBC->Execute($sql);

			$server['missionType'] = $ID;

			// return host ID
			return $ID;
		}

		// mission type isn't in our database, insert it
		$sql = "INSERT INTO `missions` (missionName, tsFirstSeen) VALUES (?, CURRENT_TIMESTAMP);";
		$res = $DBC->Execute($sql, array($server['missionType']));
		$ID  = $DBC->Insert_ID();

		$server['missionType'] = $ID;

		// return host ID
		return $ID;

	} catch (exception $e)
	{
		Safevar_dump($e);
		adodb_backtrace($e->gettrace());

		return false;
	}
}


function DBServerInfoToDBFields(&$server, $forHistory = false)
{
	$fields = array();

//	$fields['']		= $server["address"];
//	$fields['']		= $server["lastSeen"];
//	$fields['']		= $server["queryVersion"];
//	$fields['']		= $server["netCurrentVersion"];
//	$fields['']		= $server["netMinimumVersion"];

	if(!$forHistory)
	{
		$fields['hostID']	= $server["hostID"];
		$fields['port']		= $server["port"];
	}
	else
	{
		$fields['serverID']	= $server["serverID"];
	}

	$fields['gameType']		= $server["gameType"];
	$fields['missionType']	= $server["missionType"];
	$fields['status']		= $server["status"];
	$fields['playerCount']	= $server["playerCount"];
	$fields['playerMax']	= $server["playerMax"];
	$fields['botCount']		= $server["botCount"];
	$fields['cpuSpeed']		= $server["CPUSpeed"];
	$fields['gameVersion']	= $server["gameVersion"];
	$fields['name']			= $server["name"];
	$fields['missionName']	= $server["missionName"];
	$fields['info']			= $server["info"];
	$fields['infoLong']		= $server["infoLong"];

	return $fields;
}

function DBProcAndGetHostID(&$server)
{
	global $DBC, $stats;

	try
	{
		// see if host exists in our host table
		$sql = "SELECT * FROM `hosts` WHERE `hostAddress` = ? LIMIT 1;";
		$res = $DBC->Execute($sql, array($server['address']));

		if($res->fields)
		{
			$hostID = $res->fields['hostID'];

			// successfully got ID, now update last seen timestamp
			$sql = "UPDATE `hosts` SET `tsLastSeen`=CURRENT_TIMESTAMP() WHERE `hostID`='". $hostID ."';";
			$DBC->Execute($sql);

			$server['hostID'] = $hostID;

			$stats['updatedHost']++;

			// return host ID
			return $hostID;
		}

		// host isn't in our database, insert it
		$sql = "INSERT INTO `hosts` (hostAddress, tsFirstSeen) VALUES (?, CURRENT_TIMESTAMP);";
		$res = $DBC->Execute($sql, array($server['address']));
		$hostID = $DBC->Insert_ID();

		$server['hostID'] = $hostID;

		$stats['newHost']++;

		// return host ID
		return $hostID;

	} catch (exception $e)
	{
		Safevar_dump($e);
		adodb_backtrace($e->gettrace());

		return false;
	}
}

function DBProcAndGetServerID(&$server)
{
	global $DBC, $stats;
	$hostID = $server['hostID'];

	try
	{
		// see if server exists in our servers table
		$sql = "SELECT * FROM `servers` WHERE `hostID` = ? AND `port` = ? LIMIT 1;";
		$res = $DBC->Execute($sql, array($hostID, $server['port']));

		if($res->fields)
		{
			$serverID = $res->fields['serverID'];

			// successfully got ID, now update last seen timestamp
			$sql = "UPDATE `servers` SET `tsLastSeen`=CURRENT_TIMESTAMP WHERE `serverID`='". $serverID ."';";
			$DBC->Execute($sql);

			$server['serverID']	= $serverID;
			$server['isDiff']	= DBCheckServerDifferent($server, $res->fields);

			// return host ID
			return $serverID;
		}

		// server isn't in our database, insert it
		$fields = DBServerInfoToDBFields($server);

		$rs  = 'servers';
		$sql = $DBC->GetInsertSQL($rs, $fields);
		$res = $DBC->Execute($sql);
		$serverID = $DBC->Insert_ID();

		// successfully got ID, now update first and last seen timestamps,
		$sql = "UPDATE `servers` SET `tsFirstSeen`=CURRENT_TIMESTAMP, `tsLastSeen`=CURRENT_TIMESTAMP WHERE `serverID`='". $serverID ."';";
		$DBC->Execute($sql);

		$server['serverID'] = $serverID;

		$stats['new']++;

		// return server ID
		return $serverID;

	} catch (exception $e)
	{
		Safevar_dump($e);
		adodb_backtrace($e->gettrace());

		return false;
	}
}

function DBCheckServerDifferent(&$server, $fields)
{
	global $stats;


	$nfields = DBServerInfoToDBFields($server);
	unset($fields['serverID'], $fields['tsFirstSeen'], $fields['tsLastSeen']);

	// see if there's any differences
	foreach($fields as $key => $col)
	{
		if($nfields[$key] != $fields[$key])
		{
//			printf("%s is new:\n  Old: %s\n  New: %s\n",
//					$key, $fields[$key], $nfields[$key]);
			$stats['different']++;
			return true;
		}
	}

	return false;
}

function DBUpdateServerAndHistory(&$server)
{
	global $DBC, $stats;

	// oldest a history record will be since last update before it is abandoned for being too old?
	$maxAge = 10 * 60; // 10 minutes


	try
	{
		if(!isset($server['isDiff']))
			$server['isDiff'] = true;

		// has the server info changed since last recording (or is it new)?
		if($server['isDiff'] == true)
		{
			// yes, update the server record
			$fields = DBServerInfoToDBFields($server, false);
			$DBC->AutoExecute('servers', $fields, 'UPDATE', 'serverID = \''. $server['serverID'] .'\'', true);

//			$sql = "UPDATE `servers` SET `tsLastSeen`=CURRENT_TIMESTAMP WHERE `serverID`='". $server['serverID'] ."';";
//			$DBC->Execute($sql);

			$stats['updated']++;

NewHistoryRecord:
			// insert new server history record
			$fields = DBServerInfoToDBFields($server, true);
			$rs  = 'serversHistory';
			$sql = $DBC->GetInsertSQL($rs, $fields);
			$res = $DBC->Execute($sql);
			$historyID = $DBC->Insert_ID();

			$sql = "UPDATE `serversHistory` SET `tsRecorded`=CURRENT_TIMESTAMP, `tsLastMatched`=CURRENT_TIMESTAMP WHERE `serverHistoryID`='". $historyID ."';";
			$DBC->Execute($sql);

			$stats['newHistory']++;

			// done, return current history ID
			return $historyID;
		}

		// get the last history entry for this server
		$sql = "SELECT *, UNIX_TIMESTAMP(`tsLastMatched`) as `lastSeen` FROM `serversHistory` WHERE `serverID` = ? AND `tsLastMatched` >= FROM_UNIXTIME(?) ORDER BY `serverHistoryID` DESC LIMIT 1;";
//		$sql = "SELECT *, UNIX_TIMESTAMP(`tsLastMatched`) as `lastSeen` FROM `serversHistory` WHERE serverID = ? AND lastSeen >= ? ORDER BY `serverHistoryID` DESC LIMIT 1;";
		$res = $DBC->Execute($sql, array($server['serverID'], time() - $maxAge));

		if(!$res->fields)
			goto NewHistoryRecord;

		$historyID = $res->fields['serverHistoryID'];

		// update last match/seen history
		$sql = "UPDATE `serversHistory` SET `tsLastMatched`=CURRENT_TIMESTAMP WHERE `serverHistoryID`='". $historyID ."';";
		$DBC->Execute($sql);

		$stats['updatedHistory']++;

		// done, return current history ID
		return $historyID;

	} catch (exception $e)
	{
		Safevar_dump($e);
		adodb_backtrace($e->gettrace());

		return false;
	}
}

function DBUpdateStats()
{
	global $DBC, $stats;

	try
	{
		$fields['activeServers']	= $stats['active'];			// number of active servers that responded to game pings.
		$fields['newServers']		= $stats['new'];			// new servers added to servers table.
		$fields['updatedServers']	= $stats['updated'];		// updated servers in servers table.
		$fields['newHistory']		= $stats['newHistory'];		// new server history added to serversHistory table.
		$fields['updatedHistory']	= $stats['updatedHistory'];	// updated existing server history in serversHistory table.
		$fields['serversRetried']	= $stats['retries'];		// number of servers we retried contacting for game ping response.
		$fields['serversDifferent']	= $stats['different'];		// number of servers that were different from previous check
		$fields['newHosts']			= $stats['newHost'];		// number of new hosts
		$fields['updatedHosts']		= $stats['updatedHost'];	// number of updated hosts

		$rs  = 'masterStats';
//		$sql = $DBC->GetInsertSQL($rs, $fields);
//		$res = $DBC->Execute($sql);
//		$ID = $DBC->Insert_ID();

		// return stats ID
		return $ID;

	} catch (exception $e)
	{
		Safevar_dump($e);
		adodb_backtrace($e->gettrace());

		return false;
	}
}

function DBGetMasterStats($range)
{
	global $DBC;

	// convert hours into seconds
	$range *= 60 * 60;

	try
	{
		$sql = "SELECT *, UNIX_TIMESTAMP(`tsRecorded`) as `timeRecorded` FROM `masterStats` WHERE `tsRecorded` >= FROM_UNIXTIME(?) ORDER BY `tsRecorded` DESC;";
		$res = $DBC->Execute($sql, array(time() - $range));

		return $res;

	} catch (exception $e)
	{
//		var_dump($e);
//		adodb_backtrace($e->gettrace());

		return false;
	}
}

function DBGetActiveServers($age, $limit)
{
	global $DBC;

	// convert minutes into seconds
	$age *= 60;

	try
	{
		$sql = $sql = "SELECT `servers`.*,`hosts`.`hostAddress` AS `address`,`games`.`gameName` AS `gameTypeName`,`missions`.`missionName` as `missionTypeName` FROM `servers`,`hosts`,`games`,`missions` WHERE `servers`.`tsLastSeen` >= FROM_UNIXTIME(?) AND `hosts`.`hostID` = `servers`.`hostID` AND `servers`.`gameType` = `games`.`gameID` AND `servers`.`missionType` = `missions`.`missionID` ORDER BY `games`.`gameName` ASC, `servers`.`playerCount` DESC, `servers`.`name` LIMIT ". $limit .";";
		$res = $DBC->Execute($sql, array(time() - $age));

		return $res;

	} catch (exception $e)
	{
//		var_dump($e);
//		adodb_backtrace($e->gettrace());

		return false;
	}
}

function DBGetServer($serverID)
{
	global $DBC;

	try
	{
		$sql = "SELECT `servers`.*,`hosts`.`hostAddress` AS `address`,`games`.`gameName` AS `gameTypeName`,`missions`.`missionName` as `missionTypeName` FROM `servers`,`hosts`,`games`,`missions` WHERE `servers`.`serverID` = ? AND `hosts`.`hostID` = `servers`.`hostID` AND `servers`.`gameType` = `games`.`gameID` AND `servers`.`missionType` = `missions`.`missionID` LIMIT 1;";
		$res = $DBC->Execute($sql, array($serverID));

		return $res;

	} catch (exception $e)
	{
//		var_dump($e);
//		adodb_backtrace($e->gettrace());

		return false;
	}
}

function DBGetServerHistory($serverID, $range)
{
	global $DBC;

	// convert hours into seconds
	$range *= 60 * 60;

	try
	{
		$sql = "SELECT `serversHistory`.*,UNIX_TIMESTAMP(`serversHistory`.`tsLastMatched`) as `timeMatched`,`games`.`gameName` AS `gameTypeName`,`missions`.`missionName` as `missionTypeName` FROM `serversHistory`,`games`,`missions` WHERE `serversHistory`.`serverID` = ? AND `serversHistory`.`tsLastMatched` >= FROM_UNIXTIME(?) AND `serversHistory`.`gameType` = `games`.`gameID` AND `serversHistory`.`missionType` = `missions`.`missionID` ORDER BY `serversHistory`.`tsLastMatched` ASC;";
		$res = $DBC->Execute($sql, array($serverID, time() - $range));

		return $res;

	} catch (exception $e)
	{
//		var_dump($e);
//		adodb_backtrace($e->gettrace());

		return false;
	}
}


//=============================================================================
// HTML Utility Functions
//=============================================================================

function HTMLSafe($text)
{
	// translate user provided data into HTML-escaped safe content
	$str = htmlentities($text, ENT_COMPAT);

	// process control characters
	$order   = array("\r\n", "\n", "\r");
	$replace = '<br>';

	return str_replace($order, $replace, $str);
}

function TextBoxSafe($text)
{
	$str = htmlspecialchars($text, ENT_COMPAT, 'UTF-8');

	return $str;
}

function genImageTag($imageFile, $alt='', $title='')
{
	global $app;

	return sprintf('<img src="%s%s" alt="%s" title="%s">', $app['imageBase'], $imageFile, $alt, $title);
}

define('Status_Dedicated',	0x01);
define('Status_Passworded',	0x02);
define('Status_Linux',		0x04);

function genServerStatus($status)
{
	$str = '';

	if($status & Status_Dedicated)	$str .= genImageTag('shll_icon_dedicated.png',	'Dedicated Server Icon',	'Dedicated Server');
	if($status & Status_Passworded)	$str .= genImageTag('shll_icon_passworded.png', 'Passworded Server Icon',	'Password Required');
	if($status & Status_Linux)		$str .= genImageTag('shll_icon_penguin.png',	'Linux Server Icon',		'Running on Linux');

	return $str;
}

function Safeprint_r(&$var)
{
	ob_start();
	print_r($var);
	echo('<pre>'. HTMLSafe(ob_get_clean()) .'</pre>');
}

function Safevar_dump(&$var)
{
	ob_start();
	var_dump($var);
	echo('<pre>'. HTMLSafe(ob_get_clean()) .'</pre>');
}


//=============================================================================
// main()
//=============================================================================

// establish a connection with the database first
if(!DBConnect())
{
	printf("Connection to Database failed!\n");
	exit(-1);
}

// get requested page
if(isset($_GET['p']))
	$app['page'] = $_GET['p'];

switch ($app['page'])
{
	default:
	case 'main':	$page = 'main';		break;
	case 'server':	$page = 'server';	break;
}

// now bring in the requested page 
include_once('./tnm/page.'. $page .'.php');

// call the page's before HTML started function
PagePreHTML();


?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title><?php print( HTMLSafe($app['title']) ); ?></title>
	<meta HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">
	<style type="text/css">
		body {
			font-family: arial, helvetica, sans-serif;
			font-size: 18px;
			color: #E6E6E6;
			background-color: #646464;
			margin: 1em;
			padding: 0;
		}

		#script {
			font-size: 12px;
			text-align: right;
			vertical-align: middle;
		}

		a:link    { color: #E6E6E6; background: transparent; text-decoration: none; }
		a:visited { color: #E6E6E6; background: transparent; text-decoration: none; }
		a:active  { color: #212121; background: transparent; text-decoration: underline overline; }
		a:hover   { color: #212121; background: #d0d0d0;     text-decoration: underline; }

		#serverhead {
			font-size: 18px;
			font-weight: bold;
			background-color: #212121;
			text-align: center;
			vertical-align: middle;
			letter-spacing: 0.1em;
			width: 100%;
		}
		#serverhead:hover {
			font-size: 18px;
			font-weight: bold;
			background-color: #d0d0d0;
			text-align: center;
			letter-spacing: -0.1em;
		}
		#serverload {
			font-size: 10px;
			font-weight: bold;
			background-color: transparent;
			text-align: right;
			vertical-align: middle;
			letter-spacing: 0.1em;
			color: #838383;
		}


		#properties {
			overflow: auto;
			width: 600px;
			height: 120px;
			background-color: #575757;
			font-size: 14px;
			font-weight: bold;
		}

		td { white-space: nowrap; }
		.tnum {
			text-align: right;
		}

		table td			{ padding-right: 0.25em; padding-left: 0.25em; }

		.allieshead       { background-color: #838383; color: #CACACA; font-weight: bold; text-align: center; }
		.allieshead th    { padding-right: 0.25em; padding-left: 0.25em; }
		.allies1          { background-color: #0080C0; color: #C0C0C0; }
		.allies2          { background-color: #006B9F; color: #C0C0C0; }
		.allieshead:hover { background-color: #CACACA; color: #838383; font-weight: bold; text-align: center; }
		.allies1:hover    { background-color: #800000; color: #C0C0C0; }
		.allies2:hover    { background-color: #5B0000; color: #C0C0C0; }

		.alliesTI         { background-color: transparent; }
		.alliesTIH        { background-color: transparent; font-weight: bold; }
		.alliesTIB        { background-color: transparent; font-weight: normal; }

		
		.axishead         { background-color: #838383; color: #CACACA; font-weight: bold; text-align: center; }
		.axis1            { background-color: #800000; color: #C0C0C0; }
		.axis2            { background-color: #5B0000; color: #C0C0C0; }
		.axishead:hover   { background-color: #CACACA; color: #838383; font-weight: bold; text-align: center; }
		.axis1:hover      { background-color: #0080C0; color: #C0C0C0; }
		.axis2:hover      { background-color: #006B9F; color: #C0C0C0; }

		.specshead        { background-color: #838383; color: #CACACA; font-weight: bold; text-align: center; }
		.specs1           { background-color: #006600; color: #C0C0C0; }
		.specs2           { background-color: #004400; color: #C0C0C0; }
		.specshead:hover  { background-color: #CACACA; color: #838383; font-weight: bold; text-align: center; }
		.specs1:hover     { background-color: #CE6711; color: #C0C0C0; }
		.specs2:hover     { background-color: #CE6711; color: #C0C0C0; }


		.c0  { color: #000000; } .c20 { color: #743313; } .c40 { color: #670504; }
		.c1  { color: #DA0120; } .c21 { color: #A7905E; } .c41 { color: #623307; }
		.c2  { color: #00B906; } .c22 { color: #555C26; } .c42 { color: #C0BFC7; }
		.c3  { color: #E8FF19; } .c23 { color: #AEAC97; } .c43 { color: #CF9A3A; }
		.c4  { color: #170BDB; } .c24 { color: #C0BF7F; } .c44 { color: #F7F8B6; }
		.c5  { color: #23C2C6; } .c25 { color: #000000; } .c45 { color: #7F7F00; }
		.c6  { color: #E201DB; } .c26 { color: #DA0120; } .c46 { color: #007F03; }
		.c7  { color: #FFFFFF; } .c27 { color: #00B906; } .c47 { color: #BEC0BB; }
		.c8  { color: #CA7C27; } .c28 { color: #E8FF19; } .c48 { color: #7F7C0B; }
		.c9  { color: #757575; } .c29 { color: #170BDB; } .c49 { color: #C5F9C8; }
		.c10 { color: #EB9F53; } .c30 { color: #23C2C6; }
		.c11 { color: #106F59; } .c31 { color: #E201DB; }
		.c12 { color: #5A134F; } .c32 { color: #FFFFFF; }
		.c13 { color: #035AFF; } .c33 { color: #CA7C27; }
		.c14 { color: #681EA7; } .c34 { color: #757575; }
		.c15 { color: #5097C1; } .c35 { color: #CC8034; }
		.c16 { color: #BEDAC4; } .c36 { color: #DBDF70; }
		.c17 { color: #024D2C; } .c37 { color: #BBBBBB; }
		.c18 { color: #7D081B; } .c38 { color: #747228; }
		.c19 { color: #90243E; } .c39 { color: #993400; }

		.servers thead			{ background-color: #838383; color: #CACACA; font-weight: bold; text-align: center; }
		.servers:hover thead	{ background-color: #CACACA; color: #838383; font-weight: bold; text-align: center; }
		.servlist1          { background-color: #004080; color: #C0C0C0; }
		.servlist2          { background-color: #00356A; color: #C0C0C0; }
		.servlisthead:hover { background-color: #d0d0d0; color: #000000; font-weight: bold; text-align: center; }
		.servlist1:hover    { background-color: #910000; color: #FFFFFF; }
		.servlist2:hover    { background-color: #910000; color: #FFFFFF; }
		.servlistH          { background-color: #0080C0; color: #FFFFFF; }
		.servlistH:hover    { background-color: #88C4FF; }

		.servers td			{ background-repeat: no-repeat; background-position: left top; }
		.servSDed 			{ background-image: url(./tnm/imgs/shll_icon_dedicated.png); }
		.servSPass			{ background-image: url(./tnm/imgs/shll_icon_passworded.png); }
		.servSLinux			{ background-image: url(./tnm/imgs/shll_icon_penguin.png); }


	</style>
	<script src="js/jquery-1.6.1.min.js" type="text/javascript"></script>
	<script src="js/highcharts.js" type="text/javascript"></script>
	<script src="js/themes/gray.js" type="text/javascript"></script>


</head>
<body>
<?php

// call the page's after HTML started function
PagePostHTML();

?>
</body>
</html>
