<?php
	/**************************************************************************
	 *  Torque Server Query PHP Script
	 *  Copyright (C) 2011-2012 by Nathan Martin  All Rights Reserved
	 *
	 *  Author can be contacted at nmartin <AT> gmail [DOT] com
	 *  This source code is licensed under the General Public License (GPL) v2
	 *  License info: http://www.gnu.org/copyleft/gpl.html
	 *
	 *=========================================================================
	 *
	 *	This program is free software; you can redistribute it and/or
	 *	modify it under the terms of the GNU General Public License
	 *	as published by the Free Software Foundation; either version 2
	 *	of the License, or (at your option) any later version.
	 *
	 *	This program is distributed in the hope that it will be useful,
	 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
	 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 *	GNU General Public License for more details.
	 *
	 *************************************************************************/

	$ScriptName    = 'phpTorqueQuery';
	$ScriptVersion = '0.1.0';
	$ScriptRelease = 'Alpha';



function Safeprint_r(&$var)
{
	ob_start();
	print_r($var);
	echo('<pre>'. htmlentities(ob_get_clean()) .'</pre>');
}

function Safevar_dump(&$var)
{
	ob_start();
	var_dump($var);
	echo('<pre>'. htmlentities(ob_get_clean()) .'</pre>');
}

//=============================================================================
// Main System
//=============================================================================

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
	<title>Torque Server Query</title>
	<meta HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=ISO-8859-1">
	<style type="text/css">
		body {
			font-family: arial, helvetica, sans-serif;
			font-size: 18px;
			color: #E6E6E6;
			background-color: #646464;
			margin: 1em;
			padding: 0;
		}

		#script {
			font-size: 12px;
			text-align: right;
			vertical-align: middle;
		}

		a:link    { color: #E6E6E6; background: transparent; text-decoration: none; }
		a:visited { color: #E6E6E6; background: transparent; text-decoration: none; }
		a:active  { color: #212121; background: transparent; text-decoration: underline overline; }
		a:hover   { color: #212121; background: #d0d0d0;     text-decoration: underline; }

		#serverhead {
			font-size: 18px;
			font-weight: bold;
			background-color: #212121;
			text-align: center;
			vertical-align: middle;
			letter-spacing: 0.1em;
			width: 100%;
		}
		#serverhead:hover {
			font-size: 18px;
			font-weight: bold;
			background-color: #d0d0d0;
			text-align: center;
			letter-spacing: -0.1em;
		}
		#serverload {
			font-size: 10px;
			font-weight: bold;
			background-color: transparent;
			text-align: right;
			vertical-align: middle;
			letter-spacing: 0.1em;
			color: #838383;
		}


		#properties {
			overflow: auto;
			width: 600px;
			height: 120px;
			background-color: #575757;
			font-size: 14px;
			font-weight: bold;
		}

		td { white-space: nowrap; }

		.allieshead       { background-color: #838383; color: #CACACA; font-weight: bold; text-align: center; }
		.allies1          { background-color: #0080C0; color: #C0C0C0; }
		.allies2          { background-color: #006B9F; color: #C0C0C0; }
		.allieshead:hover { background-color: #CACACA; color: #838383; font-weight: bold; text-align: center; }
		.allies1:hover    { background-color: #800000; color: #C0C0C0; }
		.allies2:hover    { background-color: #5B0000; color: #C0C0C0; }

		.alliesTI         { background-color: transparent; }
		.alliesTIH        { background-color: transparent; font-weight: bold; }
		.alliesTIB        { background-color: transparent; font-weight: normal; }

		
		.axishead         { background-color: #838383; color: #CACACA; font-weight: bold; text-align: center; }
		.axis1            { background-color: #800000; color: #C0C0C0; }
		.axis2            { background-color: #5B0000; color: #C0C0C0; }
		.axishead:hover   { background-color: #CACACA; color: #838383; font-weight: bold; text-align: center; }
		.axis1:hover      { background-color: #0080C0; color: #C0C0C0; }
		.axis2:hover      { background-color: #006B9F; color: #C0C0C0; }

		.specshead        { background-color: #838383; color: #CACACA; font-weight: bold; text-align: center; }
		.specs1           { background-color: #006600; color: #C0C0C0; }
		.specs2           { background-color: #004400; color: #C0C0C0; }
		.specshead:hover  { background-color: #CACACA; color: #838383; font-weight: bold; text-align: center; }
		.specs1:hover     { background-color: #CE6711; color: #C0C0C0; }
		.specs2:hover     { background-color: #CE6711; color: #C0C0C0; }


		.c0  { color: #000000; } .c20 { color: #743313; } .c40 { color: #670504; }
		.c1  { color: #DA0120; } .c21 { color: #A7905E; } .c41 { color: #623307; }
		.c2  { color: #00B906; } .c22 { color: #555C26; } .c42 { color: #C0BFC7; }
		.c3  { color: #E8FF19; } .c23 { color: #AEAC97; } .c43 { color: #CF9A3A; }
		.c4  { color: #170BDB; } .c24 { color: #C0BF7F; } .c44 { color: #F7F8B6; }
		.c5  { color: #23C2C6; } .c25 { color: #000000; } .c45 { color: #7F7F00; }
		.c6  { color: #E201DB; } .c26 { color: #DA0120; } .c46 { color: #007F03; }
		.c7  { color: #FFFFFF; } .c27 { color: #00B906; } .c47 { color: #BEC0BB; }
		.c8  { color: #CA7C27; } .c28 { color: #E8FF19; } .c48 { color: #7F7C0B; }
		.c9  { color: #757575; } .c29 { color: #170BDB; } .c49 { color: #C5F9C8; }
		.c10 { color: #EB9F53; } .c30 { color: #23C2C6; }
		.c11 { color: #106F59; } .c31 { color: #E201DB; }
		.c12 { color: #5A134F; } .c32 { color: #FFFFFF; }
		.c13 { color: #035AFF; } .c33 { color: #CA7C27; }
		.c14 { color: #681EA7; } .c34 { color: #757575; }
		.c15 { color: #5097C1; } .c35 { color: #CC8034; }
		.c16 { color: #BEDAC4; } .c36 { color: #DBDF70; }
		.c17 { color: #024D2C; } .c37 { color: #BBBBBB; }
		.c18 { color: #7D081B; } .c38 { color: #747228; }
		.c19 { color: #90243E; } .c39 { color: #993400; }

	</style>
</head>

<body>


<?php
	//error_reporting(E_ERROR | E_PARSE | E_NOTICE);
	error_reporting(E_ALL);



/**
 * View any string as a hexdump.
 *
 * This is most commonly used to view binary data from streams
 * or sockets while debugging, but can be used to view any string
 * with non-viewable characters.
 *
 * @version     1.3.2
 * @author      Aidan Lister <aidan@php.net>
 * @author      Peter Waller <iridum@php.net>
 * @link        http://aidanlister.com/2004/04/viewing-binary-data-as-a-hexdump-in-php/
 * @param       string  $data        The string to be dumped
 * @param       bool    $htmloutput  Set to false for non-HTML output
 * @param       bool    $uppercase   Set to true for uppercase hex
 * @param       bool    $return      Set to true to return the dump
 */
function hexdump ($data, $htmloutput = true, $uppercase = false, $return = false)
{
    // Init
    $hexi   = '';
    $ascii  = '';
    $dump   = ($htmloutput === true) ? '<pre>' : '';
    $offset = 0;
    $len    = strlen($data);

    // Upper or lower case hexadecimal
    $x = ($uppercase === false) ? 'x' : 'X';

    // Iterate string
    for ($i = $j = 0; $i < $len; $i++)
    {
        // Convert to hexidecimal
        $hexi .= sprintf("%02$x ", ord($data[$i]));

        // Replace non-viewable bytes with '.'
        if (ord($data[$i]) >= 32) {
            $ascii .= ($htmloutput === true) ?
                            htmlentities($data[$i]) :
                            $data[$i];
        } else {
            $ascii .= '.';
        }

        // Add extra column spacing
        if ($j === 7) {
            $hexi  .= ' ';
            $ascii .= ' ';
        }

        // Add row
        if (++$j === 16 || $i === $len - 1) {
            // Join the hexi / ascii output
            $dump .= sprintf("%04$x  %-49s  %s", $offset, $hexi, $ascii);

            // Reset vars
            $hexi   = $ascii = '';
            $offset += 16;
            $j      = 0;

            // Add newline
            if ($i !== $len - 1) {
                $dump .= "\n";
            }
        }
    }

    // Finish dump
    $dump .= $htmloutput === true ?
                '</pre>' :
                '';
    $dump .= "\n";

    // Output method
    if ($return === false) {
        echo $dump;
    } else {
        return $dump;
    }
}

function flushnow()
{
    echo(str_repeat(' ',256));
    // check that buffer is actually set before flushing
    if (ob_get_length()){           
        @ob_flush();
        @flush();
        @ob_end_flush();
    }   
    @ob_start();
}


	function writeU64(&$data, $num)
	{
		//$data .= pack('C', $num);
	}

	function writeU32(&$data, $num)
	{
		$data .= pack('V', $num);
	}

	function writeU16(&$data, $num)
	{
		$data .= pack('v', $num);
	}

	function writeU8(&$data, $num)
	{
		$data .= pack('C', $num);
	}

	function readU64(&$data)
	{
		list(, $lolo, $lohi, $hilo, $hihi) = unpack('v*', substr($data, 0, 8));
		$data = substr($data, 8);

		return ($hihi * (0xffff+1) + $hilo) * (0xffffffff+1) + ($lohi * (0xffff+1) + $lolo);
	}

	function readU32(&$data)
	{
		list(,$val) = unpack('V', substr($data, 0, 4));
		$data       = substr($data, 4);

		return $val;
	}

	function readU16(&$data)
	{
		list(,$val) = unpack('v', substr($data, 0, 2));
		$data       = substr($data, 2);

		return $val;
	}

	function readChar(&$data)
	{
		$val  = substr($data, 0, 1);
		$data = substr($data, 1);

		return $val;
	}

	function readU8(&$data)
	{
		return ord(readChar($data));
	}

	function readNULLString(&$data)
	{
		$str = '';

		if( ($x = strpos($data, "\x00")) !== false)
		{
			$str  = substr($data, 0, $x);
			$data = substr($data, $x +1);
		}

		return $str;
	}

	function writeCString(&$data, $str)
	{
		$len = 0;

		// get string length
		$len = strlen($str);

		// clamp the string to 255 bytes
		if($len > 0xFF)
			$len = 0xFF;

		// write string length
		writeU8($data, $len);

		// write string content
		$data .= substr($str, 0, $len);
	}

	function readCString(&$data)
	{
		$str = '';
		$len = 0;

		// read string length
		$len = readU8($data);

		// abort on no length
		if(!$len)
			return $str;

		// read in string
		$str  = substr($data, 0, $len);
		$data = substr($data, $len);

		return $str;
	}

	function readLongCString(&$data)
	{
		$str = '';
		$len = 0;

		// read string length
		$len = readU16($data);

		// abort on no length
		if(!$len)
			return $str;

		// read in string
		$str  = substr($data, 0, $len);
		$data = substr($data, $len);

		return $str;
	}


	// Tribes 2 / Torque Query and Response Types
	define("MasterServerGameTypesRequest",	2);		// *
	define("MasterServerGameTypesResponse",	4);		// !
	define("MasterServerListRequest",		6);		// *
	define("MasterServerListResponse",		8);		// !
	define("GameMasterInfoRequest",			10);	// !
	define("GameMasterInfoResponse",		12);	// *
	define("GamePingRequest",				14);
	define("GamePingResponse",				16);
	define("GameInfoRequest",				18);
	define("GameInfoResponse",				20);
	define("GameHeartbeat",					22);	// *
	define("MasterServerInfoRequest",		24);	// *, Torque doesn't use this...
	define("MasterServerInfoResponse",		26);

	// Packet [Query] Flags
	define("OfflineQuery",					0x01);	// when not set, it's a OnlineQuery
	define("NoStringCompress",				0x02);	// Do not compress strings


	//=========================================================================
	// Packet Header Management
	//=========================================================================
	function createHeader($type, $flags, $session, $key)
	{
		$header = array();

		$header['type']		= $type;
		$header['flags']	= $flags;
		$header['session']	= $session;
		$header['key']		= $key;

		return $header;
	}

	function writeHeader(&$data, &$header)
	{
		writeU8( $data, $header['type']);
		writeU8( $data, $header['flags']);
		writeU16($data, $header['session']);
		writeU16($data, $header['key']);
	}

	function readHeader(&$data)
	{
		$type		= readU8($data);
		$flags		= readU8($data);
		$session	= readU16($data);
		$key		= readU16($data);

		return createHeader($type, $flags, $session, $key);
	}

	//=========================================================================
	// Game Server Lists
	//=========================================================================
	function createMasterListQuery($game, $mission)
	{
		$data = '';

		// session and key are just random numbers, so 12 and 34 will do
		$header = createHeader(MasterServerListRequest, 0x00, 12, 34);

		writeHeader( $data, $header);		// header
		writeU8(     $data, 0xFF);			// packet index - 0xFF is query, other resend packet
		writeCString($data, $game);			// game type
		writeCString($data, $mission);		// mission type
		writeU8(     $data, 0);				// min players
		writeU8(     $data, 0);				// max players
		writeU32(    $data, 0xFFFFFFFF);	// region mask  - any region
		writeU32(    $data, 0);				// min version  - any version
		writeU8(     $data, 0);				// info flags   - any server status
		writeU8(     $data, 0);				// max bots     - any bots
		writeU16(    $data, 0);				// min CPU      - any processor speed
		writeU8(     $data, 0);				// buddy count  - no buddies to provide

		return $data;
	}

	function parseMasterListResponse(&$data)
	{
		$result		= array();
		$IPv4		= array();
		$servers	= array();
		$port		= 0;
		$num		= 0;


		// set to server count, easier to debug if its first entry
		$servers['count'] = 0;

		// read packet index and total packets
		readU8($data);	// Packet Index
		readU8($data);	// Packet Total

		// read number of servers in this packet
		$num = readU16($data);
		for($i=0; $i<$num; $i++)
		{
			// read in IP address as four bytes
			for($n=0; $n<4; $n++)
				$IPv4[$n] = readU8($data);

			// read in port number
			$port = readU16($data);

			$servers[$i]['address'] = sprintf("%u.%u.%u.%u", $IPv4[0], $IPv4[1], $IPv4[2], $IPv4[3]);
			$servers[$i]['port']	= $port;
		}
		
		// update server count and servers array.
		$servers['count']	= $num;
		$result[ 'servers']	= $servers;

		// results
		return $result;
	}


	//=========================================================================
	// Misc. Master Server Information [Non-Standard]
	//=========================================================================
	function createMasterInfoQuery()
	{
		$data = '';

		// session and key are just random numbers, so 0x8C and 0xA4 will do
		$header = createHeader(MasterServerInfoRequest, 0x00, 0x8C, 0xA4);

		writeHeader( $data, $header);		// header

		return $data;
	}

	//=========================================================================
	// Game and Mission Types
	//=========================================================================
	function createMasterTypesQuery()
	{
		$data = '';

		// session and key are just random numbers, so 0x8C and 0xA4 will do
		$header = createHeader(MasterServerGameTypesRequest, 0x00, 0x8C, 0xA4);

		writeHeader( $data, $header);		// header

		return $data;
	}

	function parseMasterTypesResponse(&$data)
	{
		$result		= array();
		$games		= array();
		$missions	= array();
		$num		= 0;

		// read game types
		$num = readU8($data);
		for($i=0; $i<$num; $i++)
			$games[$i] = readCString($data);

		// read mission types
		$num = readU8($data);
		for($i=0; $i<$num; $i++)
			$missions[$i] = readCString($data);

		$result['gameTypes']	= $games;
		$result['missionTypes']	= $missions;
		
		// results
		return $result;
	}


	//=========================================================================
	// Game Ping
	//=========================================================================
	function createGamePingQuery()
	{
		$data = '';

		// session and key are just random numbers, so 0x8C and 0xA4 will do
		$header = createHeader(GamePingRequest, NoStringCompress, 0x8C, 0xA4);

		writeHeader( $data, $header);		// header

		return $data;
	}

	function parseGamePingResponse(&$data)
	{
		$result		= array();
		$games		= array();
		$missions	= array();
		$num		= 0;

		$result['queryVersion']			= readCString($data);	// Version string -- "This is basically the server query protocol version now"
		$result['netCurrentVersion']	= readU32($data);		// Network Protocol Version         (GameConnection::CurrentProtocolVersion)
		$result['netMinimumVersion']	= readU32($data);		// Network Minimum Protocol Version (GameConnection::MinRequiredProtocolVersion)
		$result['gameVersion']			= readU32($data);		// Game Version [integer]
		$result['name']					= readCString($data);	// Game Server Name

		// results
		return $result;
	}


	//=========================================================================
	// Game Information
	//=========================================================================
	function createGameInfoQuery()
	{
		$data = '';

		// session and key are just random numbers, so 0x8C and 0xA4 will do
		$header = createHeader(GameInfoRequest, NoStringCompress, 0x8C, 0xA4);

		writeHeader( $data, $header);		// header

		return $data;
	}

	function parseGameInfoResponse(&$data)
	{
		$result		= array();
		$games		= array();
		$missions	= array();
		$num		= 0;


		$result['gameType']			= readCString($data);		// Game Type
		$result['missionType']		= readCString($data);		// Mission Type
		$result['missionName']		= readCString($data);		// Mission Name
		$result['status']			= readU8($data);			// Status bitflags
		$result['playerCount']		= readU8($data);			// Player Count
		$result['playerMax']		= readU8($data);			// Player Maximum
		$result['botCount']			= readU8($data);			// Bot Count
		$result['CPUSpeed']			= readU16($data);			// Processor Speed (MHz)
		$result['info']				= readCString($data);		// Info Line
		$result['infoLong']			= readLongCString($data);	// Misc. Details

		// results
		return $result;
	}



	//=========================================================================
	// Socket Handling and Processing
	//=========================================================================
	function server_query($host, $port, &$data, $timeout = 2000)
	{
		if( ($socket = socket_create(AF_INET, SOCK_DGRAM, getprotobyname('udp'))) === FALSE )
		{
			print('Error: Could not create socket '. socket_last_error() .':'. socket_strerror(socket_last_error()));
			return false;
		}

		$rhost  = '';
		$rport  = '';
		$buffer = '';
		$num_changed_sockets = 0;

//		var_dump($host, $port, $data);

		socket_sendto($socket, $data, strlen($data), 0x100, $host, $port);

		$read = array($socket);

		$num_changed_sockets = socket_select($read, $write = NULL, $except = NULL, 0, $timeout * 1000);
		if($num_changed_sockets === false)
		{
			print 'socket_select() failed '. socket_last_error($socket) .':'. socket_strerror(socket_last_error($socket));
		} else if( ($num_changed_sockets > 0) && ($read[0] == $socket) )
		{
			socket_recvfrom($socket, $buffer, 4 * 1024, 0, $rhost, $rport);
			socket_close($socket);
//			printf("<p>Packet Received from <b><u>%s</u>:<u>%lu</u></b><p>", $rhost, $rport);

			return $buffer;
		} else {
			print("Connection timed out.\n");
		}

		socket_close($socket);
		return false;
	}


	function torqueQuery($h, $p, $type)
	{
		$dout	= '';
		$din	= '';


		switch($type)
		{
			case MasterServerGameTypesRequest:	$dout = createMasterTypesQuery(); break;
			case MasterServerListRequest:		$dout = createMasterListQuery('Any', 'Any'); break;
			case GameMasterInfoRequest:			break;
			case GamePingRequest:				$dout = createGamePingQuery(); break;
			case GameInfoRequest:				$dout = createGameInfoQuery(); break;
		}

		// send off request packet
		$din = server_query($h, $p, $dout);

		// check response
		if($din === false)
			return;

		hexdump($din);

		// read header
		$head = readHeader($din);

		// process the packet based on type
		switch($head['type'])
		{
			case MasterServerGameTypesResponse: $result = parseMasterTypesResponse($din); break;
			case MasterServerListResponse:		$result = parseMasterListResponse($din);  break;
			case MasterServerInfoResponse:		$result = parseMasterInfoResponse($din);  break;
			case GamePingResponse:				$result = parseGamePingResponse($din);    break;
			case GameInfoResponse:				$result = parseGameInfoResponse($din);    break;
		}

		if($head['type'] == MasterServerListResponse)
		{
			// try game pinging a few servers
			$num = $result['servers']['count'];

	//		if($num > 5)
	//			$num = 5;
			printf("Contacting %u servers\n<br>", $num);
			flushnow();

			$count = 0;
			for($i=0; $i<$num; $i++)
			{
				$server = &$result['servers'][$i];

				$dout = createGamePingQuery();
				$din2 = false;
				$din2 = server_query($server['address'], $server['port'], $dout, 500);
				if(!($din2 === false))
				{
					$head2	= readHeader($din2);
					hexdump($din2);
					$res	= parseGamePingResponse($din2);
					$server	= array_merge($server, $res);
					$count++;
				}

	//			$server['tried'] = $i;
			}

			printf("<br>\n%u servers responded\n<br>", $count);
		}

		// append header to results
		$header['header'] = &$head;
		$result = array_merge($header, $result);

		// dump results
		Safevar_dump($result);
		hexdump($din);
	}


	$host = "master.dottools.net:28002";
//	$host = "master.garagegames.com:28002";
//	$host = "41.238.91.89:27838";

	$port = 28002;
	if( ($x = strpos($host, ':')) !== false)
	{
		$port = substr($host, $x +1);
		$host = substr($host, 0, $x);
	}

	// testing.....
//	torqueQuery($host, $port, GamePingRequest);
//	torqueQuery($host, $port, GameInfoRequest);
	torqueQuery($host, $port, MasterServerListRequest);


?>

</body>
</html>
